program dotNetApp;

uses
  System.Runtime.InteropServices,
  System.Text,
  System.Windows.Forms;

type
  TfrmPInvoke = class(Form)
    btnHResult: Button;
    btnNoHResult: Button;
    procedure btnHResultClick(Sender: TObject; Args: EventArgs);
    procedure btnNoHResultClick(Sender: TObject; Args: EventArgs);
  public
    constructor Create;
  end;

{ TfrmPInvoke }

constructor TfrmPInvoke.Create;
begin
  inherited;
  Width := 326;
  Height := 90;
  StartPosition := FormStartPosition.CenterScreen;
  Text := '.NET App Using Win32 COM Routines';
  FormBorderStyle := FormBorderStyle.FixedSingle;
  MinimizeBox := False;
  MaximizeBox := False;
  btnHResult := Button.Create;
  with btnHResult do
  begin
    Text := 'HResult';
    SetBounds(16, 16, 137, 33);
    Parent := Self;
    Add_Click(btnHResultClick);
  end;
  btnNoHResult := Button.Create;
  with btnNoHResult do
  begin
    Text := 'No HResult';
    SetBounds(168, 16, 137, 33);
    Parent := Self;
    Add_Click(btnNoHResultClick);
  end;
end;

const
  ole32  = 'ole32.dll';

{.$define USE_PARAMETER_ATTRIBUTES}

{$ifdef USE_PARAMETER_ATTRIBUTES}

function CLSIDFromProgID1([MarshalAs(UnmanagedType.LPWStr)] ppsz: String;
  out rclsid: Guid): Integer; stdcall; external ole32 name 'CLSIDFromProgID';
[DllImport(ole32, EntryPoint = 'CLSIDFromProgID', PreserveSig = False)]
procedure CLSIDFromProgID2([MarshalAs(UnmanagedType.LPWStr)] ppsz: String;
  out rclsid: Guid); external;

{$else}

[DllImport(ole32, EntryPoint = 'CLSIDFromProgID', CharSet = CharSet.Unicode)]
function CLSIDFromProgID1(ppsz: String; out rclsid: Guid): Integer; external;
[DllImport(ole32, EntryPoint = 'CLSIDFromProgID', CharSet = CharSet.Unicode, PreserveSig = False)]
procedure CLSIDFromProgID2(ppsz: String; out rclsid: Guid); external;

{$endif}

const
  OKProgID = 'Word.Application';
  BadProgID = 'Foo.Bar';

function ProgIDToGUID1(const ProgID: String): String;
var
  AGuid: Guid;
  Res: Integer;
begin
  AGuid := Guid.Empty;
  Res := CLSIDFromProgID1(ProgID, AGuid);
  if Res >= 0 then
    Result := AGuid.ToString
  else
    raise Exception.Create(Format('Error $%x', [Res]))
end;

function ProgIDToGUID2(const ProgID: String): String;
var
  AGuid: Guid;
begin
  AGuid := Guid.Empty;
  CLSIDFromProgID2(ProgID, AGuid);
  Result := AGuid.ToString
end;

procedure TfrmPInvoke.btnHResultClick(Sender: TObject; Args: EventArgs);
begin
  MessageBox.Show(Format('GUID for %s is %s', [OKProgID, ProgIDToGUID1(OKProgID)]));
  MessageBox.Show(Format('GUID for %s is %s', [BadProgID, ProgIDToGUID1(BadProgID)]));
end;

procedure TfrmPInvoke.btnNoHResultClick(Sender: TObject; Args: EventArgs);
begin
  MessageBox.Show(Format('GUID for %s is %s', [OKProgID, ProgIDToGUID2(OKProgID)]));
  MessageBox.Show(Format('GUID for %s is %s', [BadProgID, ProgIDToGUID2(BadProgID)]));
end;

begin
  Application.Run(TfrmPInvoke.Create);
end.
